@echo off
setlocal enabledelayedexpansion

:: 替换IP为Node-Camera的实际IP
set "host=http://192.168.1.100"

:: 保存下载照片的本地目录
set "localpath=photos"

:: 输出视频文件名
set "output=out.mp4"

:: -------------------------------------------------------------------------- ::

set "listurl=%host%/sdcard?list"
set "imageurl=%host%/sdcard?image"
set "list=list.txt"

:: 删除本地目录并新建
if exist "%localpath%" (
    rmdir /s /q "%localpath%"
)
mkdir "%localpath%"

:: HTTP请求照片列表并将返回的JSON字符串保存到本地list文件
curl -s %listurl% > %list%

:: 逐行读取list文件并取逗号分隔的第一个字段 (含文件名)
set "count=0"
for /f "tokens=1 delims=," %%i in (%list%) do (
    set "filename=%%i"
    :: 去除字符串中的[
    set filename=!filename:[=!
    :: 去除字符串中的引号和空格
    set filename=!filename:"=!
    set filename=!filename: =!

    :: 判断是否匹配文件名格式IMG_xxxx.JPG
    echo !filename! | findstr /R /C:"IMG_[0-9][0-9][0-9][0-9]\.JPG" > nul
    if !errorlevel! equ 0 (
        :: 使用curl下载照片并保存到本地目录
        set src=%imageurl%=!filename!
        set dest=%localpath%\!filename!
        curl -s -o "!dest!" "!src!"

        :: 检查下载是否成功
        if %errorlevel% equ 0 (
            echo !filename! ok
            set /a "count+=1"

        ) else (
            echo !filename! failed
        )
    )
)

echo total number of images: !count!

:: 判断是否有照片
if "!count!" == "0" (
    echo no images to process
    exit /b 0
)

:: -------------------------------------------------------------------------- ::

:: 将本地目录下的照片文件以连续序号重新命名
set "counter=0"
for /f "delims=" %%f in ('dir /b /a-d /on "%localpath%"') do (
    :: 新文件名
    set "num=0000!counter!"
    set "num=!num:~-4!"
    set "newname=IMG_!num!.JPG"

    :: 重命名
    echo %%f ^> !newName!
    ren "%localpath%\%%f" "!newname!"

    :: 计数器递增
    set /a "counter+=1"
)

:: -------------------------------------------------------------------------- ::

:: 删除已有的视频文件
if exist "%output%" (
    del "%output%"
)

:: ffmpeg将照片序列转换为视频
set "input=%localpath%\IMG_%%04d.JPG"
ffmpeg -hide_banner -framerate 24 -i "%input%" -c:v libx264 -pix_fmt yuv420p -f mp4 %output%

:: 检查视频转换是否成功
echo.
if %errorlevel% equ 0 (
    echo %output% generated successfully
) else (
    echo failed to generate %output%
)
echo.

pause
endlocal