@echo off
setlocal enabledelayedexpansion

:: Replace IP with the actual IP of Node-Camera
set "host=http://192.168.1.100"

:: Local directory to save downloaded photos
set "localpath=photos"

:: Output video file name
set "output=out.mp4"

:: -------------------------------------------------------------------------- ::

set "listurl=%host%/sdcard?list"
set "imageurl=%host%/sdcard?image"
set "list=list.txt"

:: Delete the local directory and recreate it
if exist "%localpath%" (
    rmdir /s /q "%localpath%"
)
mkdir "%localpath%"

:: Make an HTTP request for the photo list and save the returned JSON string
:: to the local list file
curl -s %listurl% > %list%

:: Read the list file line by line and extract the first field separated by a
:: comma (contains the file name)
set "count=0"
for /f "tokens=1 delims=," %%i in (%list%) do (
    set "filename=%%i"
    :: Remove '[' from the string
    set filename=!filename:[=!
    :: Remove quotes and spaces from the string
    set filename=!filename:"=!
    set filename=!filename: =!

    :: Check if the filename matches the format IMG_xxxx.JPG
    echo !filename! | findstr /R /C:"IMG_[0-9][0-9][0-9][0-9]\.JPG" > nul
    if !errorlevel! equ 0 (
        :: Use curl to download the photo and save it to the local directory
        set src=%imageurl%=!filename!
        set dest=%localpath%\!filename!
        curl -s -o "!dest!" "!src!"

        :: Check if the download was successful
        if %errorlevel% equ 0 (
            echo !filename! ok
            set /a "count+=1"

        ) else (
            echo !filename! failed
        )
    )
)

echo total number of images: !count!

:: Check if there are any photos
if "!count!" == "0" (
    echo no images to process
    exit /b 0
)

:: -------------------------------------------------------------------------- ::

:: Rename photo files in the local directory with consecutive numbers
set "counter=0"
for /f "delims=" %%f in ('dir /b /a-d /on "%localpath%"') do (
    :: New file name
    set "num=0000!counter!"
    set "num=!num:~-4!"
    set "newname=IMG_!num!.JPG"

    :: Rename the file
    echo %%f ^> !newName!
    ren "%localpath%\%%f" "!newname!"

    :: Increment the counter
    set /a "counter+=1"
)

:: -------------------------------------------------------------------------- ::

:: Delete existing video file if it exists
if exist "%output%" (
    del "%output%"
)

:: Use ffmpeg to convert the photo sequence into a video
set "input=%localpath%\IMG_%%04d.JPG"
ffmpeg -hide_banner -framerate 24 -i "%input%" -c:v libx264 -pix_fmt yuv420p -f mp4 %output%

:: Check if the video conversion was successful
echo.
if %errorlevel% equ 0 (
    echo %output% generated successfully
) else (
    echo failed to generate %output%
)
echo.

pause
endlocal