@echo off
setlocal enabledelayedexpansion

:: Replace IP with the actual IP of Node-Camera
set "host=http://192.168.1.100"

:: Local directory to save downloaded photos
set "localpath=photos"

set "listurl=%host%/sdcard?list"
set "imageurl=%host%/sdcard?image"
set "list=list.txt"

:: Delete the local directory and recreate it
if exist "%localpath%" (
    rmdir /s /q "%localpath%"
)
mkdir "%localpath%"

:: Make an HTTP request for the photo list and save the returned JSON string
:: to the local list file
curl -s %listurl% > %list%

:: Read the list file line by line and extract the first field separated by a
:: comma (contains the file name)
set "count=0"
for /f "tokens=1 delims=," %%i in (%list%) do (
    set "filename=%%i"
    :: Remove '[' from the string
    set filename=!filename:[=!
    :: Remove quotes and spaces from the string
    set filename=!filename:"=!
    set filename=!filename: =!

    :: Check if the filename matches the format IMG_xxxx.JPG
    echo !filename! | findstr /R /C:"IMG_[0-9][0-9][0-9][0-9]\.JPG" > nul
    if !errorlevel! equ 0 (
        :: Use curl to download the photo and save it to the local directory
        set src=%imageurl%=!filename!
        set dest=%localpath%\!filename!
        curl -s -o "!dest!" "!src!"

        :: Check if the download was successful
        if %errorlevel% equ 0 (
            echo !filename! ok
            set /a "count+=1"

        ) else (
            echo !filename! failed
        )
    )
)

echo total number of images: !count!

pause
endlocal